<?php
        header("Access-Control-Allow-Origin: *");
require('../vendor/autoload.php');

 $ref="1//01m_m73JOyaLvCgYIARAAGAESNwF-L9IrD694_9zOQX4H7u-pvZjNahwFjjZhLeNL7ejpvy4e55kOEJJbanubUvlogKR-Ew_IO0c";

/************************************************
 * The redirect URI is to the current page, e.g:
 * http://localhost:8080/simple-file-upload.php
 ************************************************/
$redirect_uri = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];

$client = new Google_Client();
$client->setAuthConfig("../oauth-credentials.json");
$client->setRedirectUri($redirect_uri);
$client->addScope("https://www.googleapis.com/auth/drive");
 $client->setConfig('access_type', 'offline');
 $client->setAccessType('offline');
 $client->setApprovalPrompt('force');
$client->addScope(Google_Service_Drive::DRIVE);
 $service = new Google_Service_Drive($client);

// add "?logout" to the URL to remove a token from the session
if (isset($_REQUEST['logout'])) {
  file_put_contents("token","");
}

if (isset($_GET['code'])) {
  $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);
  $client->setAccessToken($token);
	
  
  // store in the session also
  $tokend = serialize($token);
  file_put_contents("token",$tokend);

  // redirect back to the example
  header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
}

// set the access token as part of the client
if (filesize("token")) {

$tokend = file_get_contents("token");
  $token = unserialize($tokend);  
  $client->setAccessToken($token);
  
  if ($client->isAccessTokenExpired()) {
	  $client->refreshToken($ref);
      $newtoken=$client->getAccessToken();
	  $tokend = serialize($newtoken);
      file_put_contents("token",$tokend);
  }

  } else {
  $authUrl = $client->createAuthUrl();

  $client->refreshToken($ref);
      $newtoken=$client->getAccessToken();
	  $tokend = serialize($newtoken);
      file_put_contents("token",$tokend);
  
 }

 $accessToken = $client->getAccessToken();
 $toke = $accessToken['access_token'];

 $folderId="13DzwXaRHUHUIYdBj-T5z_ADmBMSsuUPp";

//	Search for files in Reciever folder

  $optParams = array(
        'pageSize' => 50,
		'fields' => 'nextPageToken, files(id, name, parents)',
        'q' => "'".$folderId."' in parents and trashed=false"
        );
  $response = $service->files->listFiles($optParams);



//	loop through files in Reciever folder
	
  foreach ($response->files as $file) {

//	Prepare file info
    $emptyFileMetadata = new Google_Service_Drive_DriveFile();
    $previousParents = join(',', $file->parents);
	$fileId=$file->id;
	$filename=$file->name;
	
	
//	GET FILE EXTENSION
    $fileuid=substr($filename, 0, -4);
    $fileext= substr($filename, -4);
    $newParentId=get_parent_by_uid ($service,$fileuid);






//	Send fileID to FMRC API

	$urlJ="https://fmrcapi.000webhostapp.com/wp-json/fmrc/v1/report?code=".$fileuid;
	$resultJ = file_get_contents( $urlJ );
	$responseJ = json_decode( $resultJ );


//  LOGGING DATA
	$res = serialize($responseJ);
	$fp = fopen('gdreccopy.log', 'a');
	fwrite($fp, date("h:i:sa")."::::");
	fwrite($fp, $res);
	fwrite($fp, "\n");
	fclose($fp);


/////////////////////////////////// MOVE ///////////////////

    // Move the file to the new folder
    $file1 = $service->files->update($fileId, $emptyFileMetadata, array(
      'addParents' => $newParentId,
      'removeParents' => $previousParents,
      'fields' => 'id, parents'));

/////////////////////////////////// MOVE ///////////////////

		
}

    function get_parent_by_uid ($service,$uid){
        
        $fname=$uid;
        $response = $service->files->listFiles(array(
            'q' => "name contains '$fname' and mimeType='application/vnd.google-apps.folder'  and trashed=false"
        ));
        foreach ($response->files as $file) {
            return $file->id;
    	}
    }
















